/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_ether_common_h_
#define _mx_ether_common_h_

#define NUM_TX	((unsigned long)(MX_MCP_ETHER_TX_MASK+1) / sizeof(mcp_kreq_ether_send_t))
#define NUM_RX	((unsigned long)(MX_MCP_ETHER_RX_MASK+1) / sizeof(mcp_kreq_ether_recv_t))
#define MX_MAX_ETHER_MTU 9014

#define MX_ETH_STOPPED 0
#define MX_ETH_STOPPING 1
#define MX_ETH_STARTING 2
#define MX_ETH_RUNNING 3
#define MX_ETH_OPEN_FAILED 4

#include "mx_ether.h"
#include "mx_pio.h"

typedef struct
{
	int cnt;
	int alloc_fail;
	uint32_t *lanai_cnt;		/* lanai counter	*/
	mcp_kreq_ether_recv_t *ring;	/* lanai ptr for recvq	*/
	mcp_kreq_ether_recv_t *shadow;	/* shadow of MCP ring	*/
	struct mx_ether_buffer_info info[NUM_RX];
} mx_ether_rx_buf_t;

typedef struct
{
	int req;			/* transmits submitted	*/
	uint32_t *lanai_cnt;		/* lanai counter	*/
	mcp_kreq_ether_send_t *ring;	/* lanai ptr for sendq	*/
	struct mx_ether_buffer_info info[NUM_TX];
	int done;			/* transmits completed	*/
} mx_ether_tx_buf_t;

struct mx_ether {
	struct mx_ether_arch arch;	/* OS dependent 	*/
	int running;			/* running? 		*/
	int csum_flag;			/* rx_csums? 		*/
	mx_instance_state_t *is;	/* Hardware state 	*/
	uint8_t	current_mac[6];		/* software mac address */
	mx_ether_tx_buf_t tx;		/* transmit ring 	*/
	mx_ether_rx_buf_t rx_small;
	mx_ether_rx_buf_t rx_big;
	mx_sync_t cmd_sync;		/* sync for lanai commands */
};

int  mx_ether_open_common(mx_instance_state_t *is, int mtu, 
			  int max_small_rx, int max_big_rx);
void mx_ether_close_common(mx_instance_state_t *is);
void mx_ether_set_promisc_common(struct mx_ether *sc, int on);
void mx_ether_set_mac_address_common(struct mx_ether *sc, uint8_t *addr);
void mx_ether_start_common(mx_instance_state_t *is, int mtu,  
			  int max_small_rx, int max_big_rx);

void mx_ether_gw_rx(mx_instance_state_t *is, void *pkt);

/* copy an array of mcp_kreq_ether_send_t's to the mcp and safely
   update the sendq counter */

static inline void 
mx_ether_submit_tx_req(struct mx_ether *eth, mcp_kreq_ether_send_t *src, 
		    int cnt)
{
	int req, frag, idx;
	
	mx_always_assert (sizeof(mcp_kreq_ether_send_t) == 16);
	req = eth->tx.req;
	for (frag = 0; frag < cnt; frag++) {
		idx = req & (NUM_TX - 1);
		req++;
		mx_pio_memcpy(&eth->tx.ring[idx], &src[frag], 
			    sizeof (*src), 0);
		if (frag & 1)
			MX_STBAR();
	}
	eth->tx.req = req;
	MX_STBAR();
	
	/* update the lanai sendq counter */
	MX_PIO_WRITE(eth->tx.lanai_cnt, htonl(req));
	MX_STBAR();
}


#endif /* _mx_ether_common_h_ */

/*
  This file uses MX driver indentation.

  Local Variables:
  c-file-style:"linux"
  tab-width:8
  End:
*/
